/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.configurator.branding;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.internal.configurator.Messages;
import org.eclipse.update.internal.configurator.Utils;
import org.osgi.framework.Bundle;

public class IniFileReader {
    private static final String PID = "org.eclipse.update.configurator";
    private static final Status OK_STATUS = new Status(0, "org.eclipse.update.configurator", 0, "", null);
    private static final String KEY_PREFIX = "%";
    private static final String KEY_DOUBLE_PREFIX = "%%";
    private static final String NLS_TAG = "$nl$";
    private String featureId;
    private String pluginId;
    private String iniFilename;
    private String propertiesFilename;
    private String mappingsFilename;
    private Properties ini = null;
    private PropertyResourceBundle properties = null;
    private String[] mappings = null;
    private Bundle bundle;

    public IniFileReader(String string, String string2, String string3, String string4, String string5) {
        if (string == null || string2 == null || string3 == null) {
            throw new IllegalArgumentException();
        }
        this.featureId = string;
        this.pluginId = string2;
        this.iniFilename = string3;
        this.propertiesFilename = string4;
        this.mappingsFilename = string5;
    }

    public IStatus load() {
        if (this.ini != null) {
            return OK_STATUS;
        }
        this.bundle = Utils.getBundle(this.pluginId);
        if (this.bundle == null || this.bundle.getState() == 1 || this.bundle.getState() == 2) {
            this.bundle = null;
            String string = NLS.bind((String)Messages.IniFileReader_MissingDesc, (Object[])new String[]{this.featureId});
            return new Status(4, PID, 0, string, null);
        }
        URL uRL = null;
        Throwable throwable = null;
        uRL = FileLocator.find((Bundle)this.bundle, (IPath)new Path(NLS_TAG).append(this.iniFilename), null);
        if (uRL == null) {
            String string = NLS.bind((String)Messages.IniFileReader_OpenINIError, (Object[])new String[]{this.iniFilename});
            return new Status(4, PID, 0, string, throwable);
        }
        URL uRL2 = null;
        if (this.propertiesFilename != null & this.propertiesFilename.length() > 0) {
            uRL2 = FileLocator.find((Bundle)this.bundle, (IPath)new Path(NLS_TAG).append(this.propertiesFilename), null);
        }
        URL uRL3 = null;
        if (this.mappingsFilename != null && this.mappingsFilename.length() > 0) {
            uRL3 = FileLocator.find((Bundle)this.bundle, (IPath)new Path(NLS_TAG).append(this.mappingsFilename), null);
        }
        return this.load(uRL, uRL2, uRL3);
    }

    public String getString(String string, boolean bl, Hashtable hashtable) {
        if (this.ini == null) {
            return null;
        }
        String string2 = this.ini.getProperty(string);
        if (string2 != null && bl) {
            return this.getResourceString(string2, hashtable);
        }
        return string2;
    }

    public URL getURL(String string) {
        if (this.ini == null) {
            return null;
        }
        URL uRL = null;
        String string2 = this.ini.getProperty(string);
        if (string2 != null) {
            if (this.bundle == null) {
                return null;
            }
            uRL = FileLocator.find((Bundle)this.bundle, (IPath)new Path(string2), null);
        }
        return uRL;
    }

    public URL[] getURLs(String string) {
        URL[] uRLArray;
        if (this.ini == null || this.bundle == null) {
            return null;
        }
        String string2 = this.ini.getProperty(string);
        if (string2 == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        ArrayList<URL> arrayList = new ArrayList<URL>(10);
        while (stringTokenizer.hasMoreTokens()) {
            uRLArray = stringTokenizer.nextToken().trim();
            arrayList.add(FileLocator.find((Bundle)this.bundle, (IPath)new Path((String)uRLArray), null));
        }
        uRLArray = new URL[arrayList.size()];
        arrayList.toArray(uRLArray);
        return uRLArray;
    }

    public String getFeaturePluginLabel() {
        if (this.bundle == null) {
            return null;
        }
        return (String)this.bundle.getHeaders().get("Bundle-Name");
    }

    public String getProviderName() {
        if (this.bundle == null) {
            return null;
        }
        return (String)this.bundle.getHeaders().get("Bundle-Vendor");
    }

    public String getResourceString(String string, Hashtable hashtable) {
        String string2;
        if (string == null) {
            return null;
        }
        String string3 = string.trim();
        if (!string3.startsWith(KEY_PREFIX)) {
            return string3;
        }
        if (string3.startsWith(KEY_DOUBLE_PREFIX)) {
            return string3.substring(1);
        }
        int n = string3.indexOf(" ");
        String string4 = n == -1 ? string3 : string3.substring(0, n);
        String string5 = string2 = n == -1 ? string3 : string3.substring(n + 1);
        if (this.properties == null) {
            return string2;
        }
        String string6 = null;
        try {
            string6 = this.properties.getString(string4.substring(1));
        }
        catch (MissingResourceException missingResourceException) {
            return string2;
        }
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string7 = (String)enumeration.nextElement();
                int n2 = string6.indexOf(string7);
                if (n2 == -1) continue;
                String string8 = string6.substring(0, n2);
                String string9 = (String)hashtable.get(string7);
                String string10 = string6.substring(n2 + string7.length());
                string6 = String.valueOf(string8) + string9 + string10;
            }
        }
        if (string6.indexOf(123) != -1) {
            try {
                string6 = MessageFormat.format(string6, this.mappings);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return string6;
    }

    private IStatus load(URL uRL, URL uRL2, URL uRL3) {
        InputStream inputStream = null;
        try {
            try {
                inputStream = uRL.openStream();
                this.ini = new Properties();
                this.ini.load(inputStream);
            }
            catch (IOException iOException) {
                this.ini = null;
                String string = NLS.bind((String)Messages.IniFileReader_ReadIniError, (Object[])new String[]{uRL.toExternalForm()});
                Status status = new Status(4, PID, 0, string, (Throwable)iOException);
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException2) {}
                return status;
            }
        }
        catch (Throwable throwable) {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException iOException) {}
        if (uRL2 != null) {
            inputStream = null;
            try {
                try {
                    inputStream = uRL2.openStream();
                    this.properties = new PropertyResourceBundle(inputStream);
                }
                catch (IOException iOException) {
                    this.properties = null;
                    String string = NLS.bind((String)Messages.IniFileReader_ReadPropError, (Object[])new String[]{uRL2.toExternalForm()});
                    Status status = new Status(4, PID, 0, string, (Throwable)iOException);
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (IOException iOException3) {}
                    return status;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        PropertyResourceBundle propertyResourceBundle = null;
        if (uRL3 != null) {
            inputStream = null;
            try {
                try {
                    inputStream = uRL3.openStream();
                    propertyResourceBundle = new PropertyResourceBundle(inputStream);
                }
                catch (IOException iOException) {
                    propertyResourceBundle = null;
                    String string = NLS.bind((String)Messages.IniFileReader_ReadMapError, (Object[])new String[]{uRL3.toExternalForm()});
                    Status status = new Status(4, PID, 0, string, (Throwable)iOException);
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (IOException iOException4) {}
                    return status;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (propertyResourceBundle != null) {
            boolean bl = true;
            int n = 0;
            while (bl) {
                try {
                    arrayList.add(propertyResourceBundle.getString(Integer.toString(n)));
                }
                catch (MissingResourceException missingResourceException) {
                    bl = false;
                }
                ++n;
            }
        }
        this.mappings = arrayList.toArray(new String[arrayList.size()]);
        return OK_STATUS;
    }
}

