/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.configurator.branding;

import java.net.URL;
import java.util.Hashtable;
import org.eclipse.core.runtime.Path;
import org.eclipse.update.internal.configurator.branding.IniFileReader;

public final class AboutInfo {
    private static final String INI_FILENAME = "about.ini";
    private static final String PROPERTIES_FILENAME = "about.properties";
    private static final String MAPPINGS_FILENAME = "about.mappings";
    private String featureId;
    private String versionId = "";
    private String featurePluginLabel;
    private String providerName;
    private String appName;
    private URL windowImageURL;
    private URL[] windowImagesURLs;
    private URL aboutImageURL;
    private URL featureImageURL;
    private URL welcomePageURL;
    private String aboutText;
    private String welcomePerspective;
    private String tipsAndTricksHref;

    AboutInfo(String string) {
        this.featureId = string;
    }

    public static AboutInfo readFeatureInfo(String string, String string2, String string3) {
        IniFileReader iniFileReader = new IniFileReader(string, string3, INI_FILENAME, PROPERTIES_FILENAME, MAPPINGS_FILENAME);
        iniFileReader.load();
        AboutInfo aboutInfo = new AboutInfo(string);
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("{featureVersion}", string2);
        aboutInfo.versionId = string2;
        aboutInfo.featurePluginLabel = iniFileReader.getFeaturePluginLabel();
        aboutInfo.providerName = iniFileReader.getProviderName();
        aboutInfo.appName = iniFileReader.getString("appName", true, hashtable);
        aboutInfo.aboutText = iniFileReader.getString("aboutText", true, hashtable);
        aboutInfo.windowImageURL = iniFileReader.getURL("windowImage");
        aboutInfo.windowImagesURLs = iniFileReader.getURLs("windowImages");
        aboutInfo.aboutImageURL = iniFileReader.getURL("aboutImage");
        aboutInfo.featureImageURL = iniFileReader.getURL("featureImage");
        aboutInfo.welcomePageURL = iniFileReader.getURL("welcomePage");
        aboutInfo.welcomePerspective = iniFileReader.getString("welcomePerspective", false, hashtable);
        aboutInfo.tipsAndTricksHref = iniFileReader.getString("tipsAndTricksHref", false, hashtable);
        return aboutInfo;
    }

    public URL getAboutImageURL() {
        return this.aboutImageURL;
    }

    public URL getFeatureImageURL() {
        return this.featureImageURL;
    }

    public String getFeatureImageName() {
        if (this.featureImageURL != null) {
            Path path = new Path(this.featureImageURL.getPath());
            return path.lastSegment();
        }
        return null;
    }

    public String getFeatureLabel() {
        return this.featurePluginLabel;
    }

    public String getFeatureId() {
        return this.featureId;
    }

    public String getAboutText() {
        return this.aboutText;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getProductName() {
        return this.featurePluginLabel;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public String getVersionId() {
        return this.versionId;
    }

    public URL getWelcomePageURL() {
        return this.welcomePageURL;
    }

    public String getWelcomePerspectiveId() {
        return this.welcomePerspective;
    }

    public String getTipsAndTricksHref() {
        return this.tipsAndTricksHref;
    }

    public URL getWindowImageURL() {
        return this.windowImageURL;
    }

    public URL[] getWindowImagesURLs() {
        return this.windowImagesURLs;
    }
}

