/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.security.role;

import com.agfa.pacs.security.role.IRole;
import com.agfa.pacs.security.role.IRoleManager;
import com.agfa.pacs.security.role.Messages;
import com.agfa.pacs.security.role.impl.RoleManagerProviderFactory;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class RoleManagerFactory {
    private static IRole returnRole;

    public static IRoleManager getInstance() {
        return RoleManagerHolder.instance;
    }

    private static void invokeOnEventThread(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    public static List<IRole> convertRoles(String[] stringArray) {
        ArrayList<IRole> arrayList = new ArrayList<IRole>();
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray2[n2];
            arrayList.add(new DummyRole(string));
            ++n2;
        }
        return arrayList;
    }

    public static IRole showRoleChooserDialog(final List<IRole> list, boolean bl) {
        returnRole = null;
        if (bl) {
            Iterator<IRole> iterator = list.iterator();
            while (iterator.hasNext()) {
                if (iterator.next().getName().toUpperCase(Locale.ENGLISH).contains("ADMIN")) continue;
                iterator.remove();
            }
        }
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        RoleManagerFactory.invokeOnEventThread(new Runnable(){

            @Override
            public void run() {
                final JOptionPane jOptionPane = new JOptionPane(String.valueOf(Messages.getString("ServerConfig.BelongingToMultipleRoles")) + '\n' + Messages.getString("ServerConfig.ChooseRole"), 3, -1);
                Object[] objectArray = new JButton[list.size()];
                int n = 0;
                while (n < list.size()) {
                    final IRole iRole = (IRole)list.get(n);
                    objectArray[n] = new JButton(iRole.getName());
                    ((JComponent)objectArray[n]).setToolTipText(iRole.getFullPath());
                    ((AbstractButton)objectArray[n]).addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            jOptionPane.setValue(iRole);
                        }
                    });
                    ++n;
                }
                jOptionPane.setOptions(objectArray);
                jOptionPane.setInitialValue(objectArray[0]);
                JDialog jDialog = jOptionPane.createDialog(null, Messages.getString("ServerConfig.RoleChoosingTitle"));
                jDialog.setAlwaysOnTop(true);
                jDialog.setVisible(true);
                returnRole = (IRole)jOptionPane.getValue();
            }
        });
        return returnRole;
    }

    private static class DummyRole
    implements IRole {
        private static final long serialVersionUID = 7100067495429463153L;
        private String fullPath;

        public DummyRole(String string) {
            this.fullPath = string;
        }

        @Override
        public String getName() {
            int n = this.fullPath.lastIndexOf(47);
            if (n < 0) {
                return this.fullPath;
            }
            return this.fullPath.substring(n + 1);
        }

        @Override
        public IRole getParent() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<IRole> getChildren() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getFullPath() {
            return this.fullPath;
        }

        @Override
        public boolean equals(IRole iRole) {
            return iRole.getFullPath().equals(this.getFullPath());
        }

        @Override
        public IRole clone() {
            return this;
        }

        @Override
        public boolean isParentOf(IRole iRole) {
            throw new UnsupportedOperationException();
        }
    }

    private static class RoleManagerHolder {
        private static IRoleManager instance = RoleManagerProviderFactory.getInstance().getRoleManagerProvider().createRoleManager();

        private RoleManagerHolder() {
        }
    }
}

