/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.integration.level23.result;

import com.agfa.integration.level23.result.ErrorCode;
import java.io.Serializable;

public class ResultStatus
implements Serializable {
    private final ErrorCode code;
    private String reasonForFailure;
    private static ResultStatus OK = new ResultStatus(ErrorCode.OK);
    private static ResultStatus UNKNOWN_ERROR = new ResultStatus(ErrorCode.UNKNOWN_ERROR);
    private static ResultStatus NOT_SUPPORTED = new ResultStatus(ErrorCode.NOT_SUPPORTED);

    private ResultStatus(ErrorCode errorCode) {
        this.code = errorCode;
    }

    private ResultStatus(String string) {
        this.code = ErrorCode.FAILURE;
        this.reasonForFailure = string;
    }

    public static ResultStatus OK() {
        return OK;
    }

    public static ResultStatus UNKNOWN_ERROR() {
        return UNKNOWN_ERROR;
    }

    public static ResultStatus NOT_SUPPORTED() {
        return NOT_SUPPORTED;
    }

    public static ResultStatus NOT_SUPPORTED(String string) {
        ResultStatus resultStatus = NOT_SUPPORTED;
        resultStatus.reasonForFailure = string;
        return resultStatus;
    }

    public static ResultStatus FAILURE(String string) {
        return new ResultStatus(string);
    }

    public ErrorCode getErrorCode() {
        return this.code;
    }

    public boolean isFailed() {
        return this.code != ErrorCode.OK;
    }

    public boolean isSuccessfull() {
        return this.code == ErrorCode.OK;
    }

    public String getReasonForFailure() {
        return this.reasonForFailure;
    }
}

