/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.integration.impl;

import com.agfa.integration.ext.ExtendedFuture;
import com.agfa.integration.ext.IActorMessage;
import com.agfa.integration.ext.IStatus;
import com.agfa.integration.ext.ITransformer;
import com.agfa.integration.impl.TransformerInfo;
import com.agfa.pacs.logging.ALogger;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class SubDispatcher {
    private static ALogger log = ALogger.getLogger(SubDispatcher.class);
    private List<TransformerInfo> transformers;

    public SubDispatcher(List<TransformerInfo> list) {
        this.transformers = new ArrayList<TransformerInfo>(list);
        Collections.sort(this.transformers, new Comparator<TransformerInfo>(){

            @Override
            public int compare(TransformerInfo transformerInfo, TransformerInfo transformerInfo2) {
                return transformerInfo.priority - transformerInfo2.priority;
            }
        });
    }

    public ExtendedFuture<IStatus> dispatch(IActorMessage iActorMessage) throws UnsupportedOperationException {
        ITransformer iTransformer = null;
        Method method = null;
        for (TransformerInfo transformerInfo : this.transformers) {
            Map<String, Method> map = transformerInfo.methodResolver.resolveMethods(IActorMessage.class);
            if (map == null || (method = map.get(iActorMessage.getMethod())) == null) continue;
            iTransformer = transformerInfo.transformer;
            break;
        }
        if (method == null) {
            throw new UnsupportedOperationException();
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug("Invoking method [" + iActorMessage.getMethod() + "] on " + iTransformer);
            }
            return (ExtendedFuture)method.invoke(iTransformer, iActorMessage);
        }
        catch (Exception exception) {
            log.error("Method call failed", (Throwable)exception);
            throw new UnsupportedOperationException(exception);
        }
    }
}

