/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.integration.impl;

import com.agfa.integration.IDesktopIntegrationProvider;
import com.agfa.integration.ext.DoneTask;
import com.agfa.integration.ext.ExtendedFuture;
import com.agfa.integration.ext.IActor;
import com.agfa.integration.ext.IActorDispatcher;
import com.agfa.integration.ext.IActorMessage;
import com.agfa.integration.ext.ISecurityContext;
import com.agfa.integration.ext.ISimpleActor;
import com.agfa.integration.ext.IStatus;
import com.agfa.integration.impl.ActorInfo;
import com.agfa.integration.impl.ActorMessage;
import com.agfa.integration.impl.IntegrationFramework;
import com.agfa.integration.impl.Status;
import com.agfa.integration.impl.SubDispatcher;
import com.agfa.integration.impl.TransformerInfo;
import com.agfa.integration.impl.factory.ActorFactory;
import com.agfa.integration.impl.factory.SimpleActorFactory;
import com.agfa.integration.impl.factory.TransformerFactory;
import com.agfa.pacs.logging.ALogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class ActorDispatcher {
    private static ALogger log = ALogger.getLogger(ActorDispatcher.class);
    private Map<String, SubDispatcher> actor2Transformers = new HashMap<String, SubDispatcher>();
    private IntegrationFramework fdispatcher;
    private List<IActor> startedActors = new LinkedList<IActor>();
    private Map<String, ISimpleActor> startedSActors = new HashMap<String, ISimpleActor>();

    public ActorDispatcher(IntegrationFramework integrationFramework, boolean bl) {
        this.fdispatcher = integrationFramework;
        this.init(bl ? StartType.Jumpstart : StartType.Full);
    }

    private void init(StartType startType) {
        Object object;
        Object object2;
        ActorInfo[] actorInfoArray;
        IDesktopIntegrationProvider iDesktopIntegrationProvider = this.fdispatcher.getProvider();
        ActorInfo[] actorInfoArray2 = actorInfoArray = this.getActors();
        int n = actorInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            block12: {
                block14: {
                    block13: {
                        object2 = actorInfoArray2[n2];
                        if (startType == StartType.Jumpstart && !object2.inJumpstart) break block12;
                        object = null;
                        if (startType != StartType.Jumpstart) break block13;
                        object = object2.actor.initConfiguration();
                        if (object != null) break block14;
                        break block12;
                    }
                    if (!iDesktopIntegrationProvider.isActorActive(object2.name)) break block12;
                    object = iDesktopIntegrationProvider.getActorProperties(object2.name);
                }
                if (startType == StartType.LoadOther && this.startedActors.contains(object2.actor)) {
                    object2.actor.start(null, (Properties)object);
                } else {
                    this.startActor((ActorInfo)object2, (Properties)object);
                }
            }
            ++n2;
        }
        object = object2 = this.getSimpleActors();
        int n3 = ((TransformerInfo[])object2).length;
        n = 0;
        while (n < n3) {
            block15: {
                Properties properties;
                ISimpleActor iSimpleActor;
                TransformerInfo transformerInfo;
                block17: {
                    block16: {
                        transformerInfo = object[n];
                        if (startType == StartType.Jumpstart && !transformerInfo.inJumpstart) break block15;
                        iSimpleActor = (ISimpleActor)transformerInfo.transformer;
                        properties = new Properties();
                        if (startType != StartType.Jumpstart) break block16;
                        properties = iSimpleActor.initConfiguration();
                        if (properties != null) break block17;
                        break block15;
                    }
                    if (!iDesktopIntegrationProvider.isActorActive(transformerInfo.name)) break block15;
                    properties = iDesktopIntegrationProvider.getActorProperties(transformerInfo.name);
                }
                if (startType == StartType.LoadOther && this.startedSActors.containsKey(transformerInfo.name)) {
                    iSimpleActor.start(properties);
                } else {
                    this.startActor(iSimpleActor, transformerInfo.name, properties);
                }
            }
            ++n;
        }
    }

    public void initFull() {
        this.init(StartType.LoadOther);
    }

    public void shutdown() {
        for (ISimpleActor object : this.startedSActors.values()) {
            object.stop();
        }
        for (IActor iActor : this.startedActors) {
            iActor.stop();
        }
        this.actor2Transformers.clear();
    }

    public boolean isActorRunning(String string) {
        boolean bl = this.actor2Transformers.containsKey(string);
        if (bl) {
            return true;
        }
        return this.startedSActors.containsKey(string);
    }

    public boolean stopActor(ActorInfo actorInfo) {
        actorInfo.actor.stop();
        this.actor2Transformers.remove(actorInfo.name);
        return this.startedActors.remove(actorInfo.actor);
    }

    protected IActorDispatcher createActorDispatcher(String string) {
        return new PrivateActorDispatcher(string);
    }

    public boolean startActor(ActorInfo actorInfo, Properties properties) {
        actorInfo.actor.start(this.createActorDispatcher(actorInfo.name), properties);
        this.startedActors.add(actorInfo.actor);
        ArrayList<TransformerInfo> arrayList = new ArrayList<TransformerInfo>();
        TransformerInfo[] transformerInfoArray = this.getTransformers();
        int n = transformerInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            TransformerInfo transformerInfo = transformerInfoArray[n2];
            if (transformerInfo.forActor.equals(actorInfo.name)) {
                arrayList.add(transformerInfo);
            }
            ++n2;
        }
        this.actor2Transformers.put(actorInfo.name, new SubDispatcher(arrayList));
        for (TransformerInfo transformerInfo : arrayList) {
            transformerInfo.transformer.init(this.fdispatcher, actorInfo.actor, transformerInfo.properties);
        }
        return true;
    }

    public boolean startActor(ISimpleActor iSimpleActor, String string, Properties properties) {
        iSimpleActor.init(this.fdispatcher, null, null);
        iSimpleActor.start(properties);
        this.startedSActors.put(string, iSimpleActor);
        return true;
    }

    public boolean stopActor(ISimpleActor iSimpleActor, String string) {
        iSimpleActor.stop();
        this.startedSActors.remove(string);
        return true;
    }

    private ExtendedFuture<IStatus> sendMessageInImpl(String string, IActorMessage iActorMessage) {
        SubDispatcher subDispatcher;
        if (log.isDebugEnabled()) {
            log.debug("Processing method call [" + iActorMessage.getMethod() + "]");
        }
        if ((subDispatcher = this.actor2Transformers.get(string)) == null) {
            String string2 = "No transformer for actor [" + string + "]";
            log.error(string2);
            return new DoneTask(new Status(IStatus.ErrorCode.FrameworkError, string2));
        }
        try {
            iActorMessage.put("source", string);
            if (log.isDebugEnabled()) {
                log.debug("Dispatching method call [" + iActorMessage.getMethod() + "] to " + subDispatcher);
            }
            return this.dispatch(subDispatcher, iActorMessage);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            String string3 = "No transformer implements the method [" + iActorMessage.getMethod() + "] for actor [" + string + "]";
            log.warn(string3);
            return new DoneTask(new Status(IStatus.ErrorCode.UnsupportedCommand, string3));
        }
    }

    protected ExtendedFuture<IStatus> dispatch(SubDispatcher subDispatcher, IActorMessage iActorMessage) {
        return subDispatcher.dispatch(iActorMessage);
    }

    private ExtendedFuture<IStatus> sendMessageInImpl(String string, String string2, Map<String, String> map, ISecurityContext iSecurityContext, Object object) {
        ActorMessage actorMessage = new ActorMessage(string2, map);
        if (iSecurityContext != null) {
            actorMessage.setSecurityContext(iSecurityContext);
        }
        if (object != null) {
            actorMessage.setActorObject(object);
        }
        actorMessage.put("source", string);
        return this.sendMessageInImpl(string, actorMessage);
    }

    protected ActorInfo[] getActors() {
        return ActorFactory.getInstance().getActors();
    }

    protected TransformerInfo[] getTransformers() {
        return TransformerFactory.getInstance().getTransformers();
    }

    protected TransformerInfo[] getSimpleActors() {
        return SimpleActorFactory.getActors();
    }

    protected class PrivateActorDispatcher
    implements IActorDispatcher {
        private String actorName;

        public PrivateActorDispatcher(String string) {
            this.actorName = string;
        }

        @Override
        public ExtendedFuture<IStatus> sendMessageIn(IActorMessage iActorMessage) {
            return ActorDispatcher.this.sendMessageInImpl(this.actorName, iActorMessage);
        }

        @Override
        public ExtendedFuture<IStatus> sendMessageIn(String string, Map<String, String> map, ISecurityContext iSecurityContext, Object object) {
            return ActorDispatcher.this.sendMessageInImpl(this.actorName, string, map, iSecurityContext, object);
        }

        @Override
        public ExtendedFuture<IStatus> sendMessageIn(String string, Map<String, String> map, ISecurityContext iSecurityContext) {
            return ActorDispatcher.this.sendMessageInImpl(this.actorName, string, map, iSecurityContext, null);
        }

        @Override
        public ExtendedFuture<IStatus> sendMessageIn(String string, Map<String, String> map) {
            return ActorDispatcher.this.sendMessageInImpl(this.actorName, string, map, null, null);
        }
    }

    private static enum StartType {
        Full,
        Jumpstart,
        LoadOther;

    }
}

