/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.integration.ext;

import com.agfa.integration.ext.ExtendedFuture;
import com.agfa.integration.ext.IStatus;
import com.agfa.integration.impl.Status;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class CombinedFuture
implements ExtendedFuture<IStatus> {
    private List<ExtendedFuture<IStatus>> tasks;
    private List<PropertyChangeListener> listeners = new LinkedList<PropertyChangeListener>();
    private CombinedListener myListener = new CombinedListener();

    public CombinedFuture(List<ExtendedFuture<IStatus>> list) {
        this.tasks = list;
        for (ExtendedFuture<IStatus> extendedFuture : list) {
            extendedFuture.addListener(this.myListener);
        }
    }

    @Override
    public void addListener(PropertyChangeListener propertyChangeListener) {
        if (!this.listeners.contains(propertyChangeListener)) {
            this.listeners.add(propertyChangeListener);
        }
    }

    @Override
    public IStatus getNoInterruption() {
        try {
            return this.get();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public void setDone(IStatus.ErrorCode errorCode) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean cancel(boolean bl) {
        return false;
    }

    @Override
    public IStatus get() throws InterruptedException, ExecutionException {
        boolean bl = false;
        for (ExtendedFuture<IStatus> extendedFuture : this.tasks) {
            IStatus iStatus = (IStatus)extendedFuture.get();
            if (!iStatus.isFailed()) continue;
            bl = true;
            break;
        }
        return new Status(bl ? IStatus.ErrorCode.UnspecifiedError : null);
    }

    @Override
    public IStatus get(long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        boolean bl = false;
        long l2 = timeUnit.toMillis(l);
        for (ExtendedFuture<IStatus> extendedFuture : this.tasks) {
            long l3 = System.currentTimeMillis();
            IStatus iStatus = (IStatus)extendedFuture.get(l2, TimeUnit.MILLISECONDS);
            l2 -= System.currentTimeMillis() - l3;
            if (iStatus.isFailed()) {
                bl = true;
                break;
            }
            if (l2 >= 0L) continue;
            throw new TimeoutException();
        }
        return new Status(bl ? IStatus.ErrorCode.UnspecifiedError : null);
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return false;
    }

    private class CombinedListener
    implements PropertyChangeListener {
        private int count = 0;
        private boolean failed = false;

        private CombinedListener() {
        }

        @Override
        public synchronized void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            ++this.count;
            if (((IStatus)propertyChangeEvent.getNewValue()).isFailed()) {
                this.failed = true;
            }
            if (this.count == CombinedFuture.this.tasks.size() || this.failed) {
                IStatus.ErrorCode errorCode = this.failed ? IStatus.ErrorCode.UnspecifiedError : IStatus.ErrorCode.OK;
                PropertyChangeEvent propertyChangeEvent2 = new PropertyChangeEvent(CombinedFuture.this, "value", null, new Status(errorCode));
                for (PropertyChangeListener propertyChangeListener : CombinedFuture.this.listeners) {
                    propertyChangeListener.propertyChange(propertyChangeEvent2);
                }
                CombinedFuture.this.listeners = null;
            }
        }
    }
}

